package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{EnvironmentId, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentDetailsEntity(
    jobId: JobId,
    environmentId: EnvironmentId,
    schemaVersion: String,
    template: zio.aws.deadline.model.Document
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.EnvironmentDetailsEntity = {
    import EnvironmentDetailsEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.EnvironmentDetailsEntity
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .schemaVersion(schemaVersion: java.lang.String)
      .template(template)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.EnvironmentDetailsEntity.ReadOnly =
    zio.aws.deadline.model.EnvironmentDetailsEntity.wrap(buildAwsValue())
}
object EnvironmentDetailsEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.EnvironmentDetailsEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.EnvironmentDetailsEntity =
      zio.aws.deadline.model.EnvironmentDetailsEntity(
        jobId,
        environmentId,
        schemaVersion,
        template
      )
    def jobId: JobId
    def environmentId: EnvironmentId
    def schemaVersion: String
    def template: software.amazon.awssdk.core.document.Document
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getSchemaVersion: ZIO[Any, Nothing, String] = ZIO.succeed(schemaVersion)
    def getTemplate
        : ZIO[Any, Nothing, software.amazon.awssdk.core.document.Document] =
      ZIO.succeed(template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentDetailsEntity
  ) extends zio.aws.deadline.model.EnvironmentDetailsEntity.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
    override val schemaVersion: String = impl.schemaVersion(): String
    override val template: software.amazon.awssdk.core.document.Document =
      impl.template()
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentDetailsEntity
  ): zio.aws.deadline.model.EnvironmentDetailsEntity.ReadOnly = new Wrapper(
    impl
  )
}
