package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{EnvironmentId, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentDetailsError(
    jobId: JobId,
    environmentId: EnvironmentId,
    code: zio.aws.deadline.model.JobEntityErrorCode,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.EnvironmentDetailsError = {
    import EnvironmentDetailsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.EnvironmentDetailsError
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .code(code.unwrap)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.EnvironmentDetailsError.ReadOnly =
    zio.aws.deadline.model.EnvironmentDetailsError.wrap(buildAwsValue())
}
object EnvironmentDetailsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.EnvironmentDetailsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.EnvironmentDetailsError =
      zio.aws.deadline.model.EnvironmentDetailsError(
        jobId,
        environmentId,
        code,
        message
      )
    def jobId: JobId
    def environmentId: EnvironmentId
    def code: zio.aws.deadline.model.JobEntityErrorCode
    def message: String
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getCode: ZIO[Any, Nothing, zio.aws.deadline.model.JobEntityErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentDetailsError
  ) extends zio.aws.deadline.model.EnvironmentDetailsError.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
    override val code: zio.aws.deadline.model.JobEntityErrorCode =
      zio.aws.deadline.model.JobEntityErrorCode.wrap(impl.code())
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentDetailsError
  ): zio.aws.deadline.model.EnvironmentDetailsError.ReadOnly = new Wrapper(impl)
}
