package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{EnvironmentId, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentDetailsIdentifiers(
    jobId: JobId,
    environmentId: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.EnvironmentDetailsIdentifiers = {
    import EnvironmentDetailsIdentifiers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.EnvironmentDetailsIdentifiers
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.EnvironmentDetailsIdentifiers.ReadOnly =
    zio.aws.deadline.model.EnvironmentDetailsIdentifiers.wrap(buildAwsValue())
}
object EnvironmentDetailsIdentifiers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.EnvironmentDetailsIdentifiers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.EnvironmentDetailsIdentifiers =
      zio.aws.deadline.model.EnvironmentDetailsIdentifiers(jobId, environmentId)
    def jobId: JobId
    def environmentId: EnvironmentId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentDetailsIdentifiers
  ) extends zio.aws.deadline.model.EnvironmentDetailsIdentifiers.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentDetailsIdentifiers
  ): zio.aws.deadline.model.EnvironmentDetailsIdentifiers.ReadOnly =
    new Wrapper(impl)
}
