package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentEnterSessionActionDefinition(
    environmentId: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinition = {
    import EnvironmentEnterSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinition
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition
      .wrap(buildAwsValue())
}
object EnvironmentEnterSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition =
      zio.aws.deadline.model
        .EnvironmentEnterSessionActionDefinition(environmentId)
    def environmentId: EnvironmentId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinition
  ) extends zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinition
  ): zio.aws.deadline.model.EnvironmentEnterSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
