package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentEnterSessionActionDefinitionSummary(
    environmentId: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinitionSummary = {
    import EnvironmentEnterSessionActionDefinitionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinitionSummary
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary.ReadOnly =
    zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary
      .wrap(buildAwsValue())
}
object EnvironmentEnterSessionActionDefinitionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinitionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary =
      zio.aws.deadline.model
        .EnvironmentEnterSessionActionDefinitionSummary(environmentId)
    def environmentId: EnvironmentId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinitionSummary
  ) extends zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinitionSummary
  ): zio.aws.deadline.model.EnvironmentEnterSessionActionDefinitionSummary.ReadOnly =
    new Wrapper(impl)
}
