package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentExitSessionActionDefinition(
    environmentId: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinition = {
    import EnvironmentExitSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinition
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.EnvironmentExitSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.EnvironmentExitSessionActionDefinition
      .wrap(buildAwsValue())
}
object EnvironmentExitSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.EnvironmentExitSessionActionDefinition =
      zio.aws.deadline.model
        .EnvironmentExitSessionActionDefinition(environmentId)
    def environmentId: EnvironmentId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinition
  ) extends zio.aws.deadline.model.EnvironmentExitSessionActionDefinition.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinition
  ): zio.aws.deadline.model.EnvironmentExitSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
