package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentExitSessionActionDefinitionSummary(
    environmentId: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinitionSummary = {
    import EnvironmentExitSessionActionDefinitionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinitionSummary
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary.ReadOnly =
    zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary
      .wrap(buildAwsValue())
}
object EnvironmentExitSessionActionDefinitionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinitionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary =
      zio.aws.deadline.model
        .EnvironmentExitSessionActionDefinitionSummary(environmentId)
    def environmentId: EnvironmentId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinitionSummary
  ) extends zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinitionSummary
  ): zio.aws.deadline.model.EnvironmentExitSessionActionDefinitionSummary.ReadOnly =
    new Wrapper(impl)
}
