package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FieldSortExpression(
    sortOrder: zio.aws.deadline.model.SortOrder,
    name: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.FieldSortExpression = {
    import FieldSortExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.FieldSortExpression
      .builder()
      .sortOrder(sortOrder.unwrap)
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.FieldSortExpression.ReadOnly =
    zio.aws.deadline.model.FieldSortExpression.wrap(buildAwsValue())
}
object FieldSortExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.FieldSortExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.FieldSortExpression =
      zio.aws.deadline.model.FieldSortExpression(sortOrder, name)
    def sortOrder: zio.aws.deadline.model.SortOrder
    def name: String
    def getSortOrder: ZIO[Any, Nothing, zio.aws.deadline.model.SortOrder] =
      ZIO.succeed(sortOrder)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.FieldSortExpression
  ) extends zio.aws.deadline.model.FieldSortExpression.ReadOnly {
    override val sortOrder: zio.aws.deadline.model.SortOrder =
      zio.aws.deadline.model.SortOrder.wrap(impl.sortOrder())
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.FieldSortExpression
  ): zio.aws.deadline.model.FieldSortExpression.ReadOnly = new Wrapper(impl)
}
