package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{PathString, FileSystemLocationName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FileSystemLocation(
    name: FileSystemLocationName,
    path: PathString,
    `type`: zio.aws.deadline.model.FileSystemLocationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.FileSystemLocation = {
    import FileSystemLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.FileSystemLocation
      .builder()
      .name(FileSystemLocationName.unwrap(name): java.lang.String)
      .path(PathString.unwrap(path): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.FileSystemLocation.ReadOnly =
    zio.aws.deadline.model.FileSystemLocation.wrap(buildAwsValue())
}
object FileSystemLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.FileSystemLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.FileSystemLocation =
      zio.aws.deadline.model.FileSystemLocation(name, path, `type`)
    def name: FileSystemLocationName
    def path: PathString
    def `type`: zio.aws.deadline.model.FileSystemLocationType
    def getName: ZIO[Any, Nothing, FileSystemLocationName] = ZIO.succeed(name)
    def getPath: ZIO[Any, Nothing, PathString] = ZIO.succeed(path)
    def getType
        : ZIO[Any, Nothing, zio.aws.deadline.model.FileSystemLocationType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.FileSystemLocation
  ) extends zio.aws.deadline.model.FileSystemLocation.ReadOnly {
    override val name: FileSystemLocationName =
      zio.aws.deadline.model.primitives.FileSystemLocationName(impl.name())
    override val path: PathString =
      zio.aws.deadline.model.primitives.PathString(impl.path())
    override val `type`: zio.aws.deadline.model.FileSystemLocationType =
      zio.aws.deadline.model.FileSystemLocationType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.FileSystemLocation
  ): zio.aws.deadline.model.FileSystemLocation.ReadOnly = new Wrapper(impl)
}
