package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait FileSystemLocationType {
  def unwrap
      : software.amazon.awssdk.services.deadline.model.FileSystemLocationType
}
object FileSystemLocationType {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.FileSystemLocationType
  ): zio.aws.deadline.model.FileSystemLocationType = value match {
    case software.amazon.awssdk.services.deadline.model.FileSystemLocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.FileSystemLocationType.SHARED =>
      val r = SHARED
      r
    case software.amazon.awssdk.services.deadline.model.FileSystemLocationType.LOCAL =>
      val r = LOCAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.FileSystemLocationType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FileSystemLocationType =
      software.amazon.awssdk.services.deadline.model.FileSystemLocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object SHARED extends zio.aws.deadline.model.FileSystemLocationType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FileSystemLocationType =
      software.amazon.awssdk.services.deadline.model.FileSystemLocationType.SHARED
  }
  case object LOCAL extends zio.aws.deadline.model.FileSystemLocationType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FileSystemLocationType =
      software.amazon.awssdk.services.deadline.model.FileSystemLocationType.LOCAL
  }
}
