package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{EndsAt, StartsAt}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FixedBudgetSchedule(startTime: StartsAt, endTime: EndsAt) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.FixedBudgetSchedule = {
    import FixedBudgetSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.FixedBudgetSchedule
      .builder()
      .startTime(StartsAt.unwrap(startTime): Instant)
      .endTime(EndsAt.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.FixedBudgetSchedule.ReadOnly =
    zio.aws.deadline.model.FixedBudgetSchedule.wrap(buildAwsValue())
}
object FixedBudgetSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.FixedBudgetSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.FixedBudgetSchedule =
      zio.aws.deadline.model.FixedBudgetSchedule(startTime, endTime)
    def startTime: StartsAt
    def endTime: EndsAt
    def getStartTime: ZIO[Any, Nothing, StartsAt] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, EndsAt] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.FixedBudgetSchedule
  ) extends zio.aws.deadline.model.FixedBudgetSchedule.ReadOnly {
    override val startTime: StartsAt =
      zio.aws.deadline.model.primitives.StartsAt(impl.startTime())
    override val endTime: EndsAt =
      zio.aws.deadline.model.primitives.EndsAt(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.FixedBudgetSchedule
  ): zio.aws.deadline.model.FixedBudgetSchedule.ReadOnly = new Wrapper(impl)
}
