package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.AmountCapabilityName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FleetAmountCapability(
    name: AmountCapabilityName,
    min: Float,
    max: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.FleetAmountCapability = {
    import FleetAmountCapability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.FleetAmountCapability
      .builder()
      .name(AmountCapabilityName.unwrap(name): java.lang.String)
      .min(min: java.lang.Float)
      .optionallyWith(max.map(value => value: java.lang.Float))(_.max)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.FleetAmountCapability.ReadOnly =
    zio.aws.deadline.model.FleetAmountCapability.wrap(buildAwsValue())
}
object FleetAmountCapability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.FleetAmountCapability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.FleetAmountCapability =
      zio.aws.deadline.model
        .FleetAmountCapability(name, min, max.map(value => value))
    def name: AmountCapabilityName
    def min: Float
    def max: Optional[Float]
    def getName: ZIO[Any, Nothing, AmountCapabilityName] = ZIO.succeed(name)
    def getMin: ZIO[Any, Nothing, Float] = ZIO.succeed(min)
    def getMax: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.FleetAmountCapability
  ) extends zio.aws.deadline.model.FleetAmountCapability.ReadOnly {
    override val name: AmountCapabilityName =
      zio.aws.deadline.model.primitives.AmountCapabilityName(impl.name())
    override val min: Float = impl.min(): Float
    override val max: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.FleetAmountCapability
  ): zio.aws.deadline.model.FleetAmountCapability.ReadOnly = new Wrapper(impl)
}
