package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FleetCapabilities(
    amounts: Optional[Iterable[zio.aws.deadline.model.FleetAmountCapability]] =
      Optional.Absent,
    attributes: Optional[
      Iterable[zio.aws.deadline.model.FleetAttributeCapability]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.FleetCapabilities = {
    import FleetCapabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.FleetCapabilities
      .builder()
      .optionallyWith(
        amounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.amounts)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.FleetCapabilities.ReadOnly =
    zio.aws.deadline.model.FleetCapabilities.wrap(buildAwsValue())
}
object FleetCapabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.FleetCapabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.FleetCapabilities =
      zio.aws.deadline.model.FleetCapabilities(
        amounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def amounts
        : Optional[List[zio.aws.deadline.model.FleetAmountCapability.ReadOnly]]
    def attributes: Optional[
      List[zio.aws.deadline.model.FleetAttributeCapability.ReadOnly]
    ]
    def getAmounts: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FleetAmountCapability.ReadOnly
    ]] = AwsError.unwrapOptionField("amounts", amounts)
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FleetAttributeCapability.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.FleetCapabilities
  ) extends zio.aws.deadline.model.FleetCapabilities.ReadOnly {
    override val amounts: Optional[
      List[zio.aws.deadline.model.FleetAmountCapability.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.FleetAmountCapability.wrap(item)
        }.toList
      )
    override val attributes: Optional[
      List[zio.aws.deadline.model.FleetAttributeCapability.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.FleetAttributeCapability.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.FleetCapabilities
  ): zio.aws.deadline.model.FleetCapabilities.ReadOnly = new Wrapper(impl)
}
