package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FleetConfiguration(
    customerManaged: Optional[
      zio.aws.deadline.model.CustomerManagedFleetConfiguration
    ] = Optional.Absent,
    serviceManagedEc2: Optional[
      zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.FleetConfiguration = {
    import FleetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.FleetConfiguration
      .builder()
      .optionallyWith(customerManaged.map(value => value.buildAwsValue()))(
        _.customerManaged
      )
      .optionallyWith(serviceManagedEc2.map(value => value.buildAwsValue()))(
        _.serviceManagedEc2
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.FleetConfiguration.ReadOnly =
    zio.aws.deadline.model.FleetConfiguration.wrap(buildAwsValue())
}
object FleetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.FleetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.FleetConfiguration =
      zio.aws.deadline.model.FleetConfiguration(
        customerManaged.map(value => value.asEditable),
        serviceManagedEc2.map(value => value.asEditable)
      )
    def customerManaged: Optional[
      zio.aws.deadline.model.CustomerManagedFleetConfiguration.ReadOnly
    ]
    def serviceManagedEc2: Optional[
      zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration.ReadOnly
    ]
    def getCustomerManaged: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.CustomerManagedFleetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("customerManaged", customerManaged)
    def getServiceManagedEc2: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("serviceManagedEc2", serviceManagedEc2)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.FleetConfiguration
  ) extends zio.aws.deadline.model.FleetConfiguration.ReadOnly {
    override val customerManaged: Optional[
      zio.aws.deadline.model.CustomerManagedFleetConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerManaged())
      .map(value =>
        zio.aws.deadline.model.CustomerManagedFleetConfiguration.wrap(value)
      )
    override val serviceManagedEc2: Optional[
      zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceManagedEc2())
      .map(value =>
        zio.aws.deadline.model.ServiceManagedEc2FleetConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.FleetConfiguration
  ): zio.aws.deadline.model.FleetConfiguration.ReadOnly = new Wrapper(impl)
}
