package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait FleetStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.FleetStatus
}
object FleetStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.FleetStatus
  ): zio.aws.deadline.model.FleetStatus = value match {
    case software.amazon.awssdk.services.deadline.model.FleetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.FleetStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.deadline.model.FleetStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.FleetStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.FleetStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.deadline.model.FleetStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.FleetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FleetStatus =
      software.amazon.awssdk.services.deadline.model.FleetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.deadline.model.FleetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FleetStatus =
      software.amazon.awssdk.services.deadline.model.FleetStatus.ACTIVE
  }
  case object CREATE_IN_PROGRESS extends zio.aws.deadline.model.FleetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FleetStatus =
      software.amazon.awssdk.services.deadline.model.FleetStatus.CREATE_IN_PROGRESS
  }
  case object UPDATE_IN_PROGRESS extends zio.aws.deadline.model.FleetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FleetStatus =
      software.amazon.awssdk.services.deadline.model.FleetStatus.UPDATE_IN_PROGRESS
  }
  case object CREATE_FAILED extends zio.aws.deadline.model.FleetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FleetStatus =
      software.amazon.awssdk.services.deadline.model.FleetStatus.CREATE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.deadline.model.FleetStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.FleetStatus =
      software.amazon.awssdk.services.deadline.model.FleetStatus.UPDATE_FAILED
  }
}
