package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{BudgetId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetBudgetRequest(farmId: FarmId, budgetId: BudgetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetBudgetRequest = {
    import GetBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetBudgetRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .budgetId(BudgetId.unwrap(budgetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetBudgetRequest.ReadOnly =
    zio.aws.deadline.model.GetBudgetRequest.wrap(buildAwsValue())
}
object GetBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetBudgetRequest =
      zio.aws.deadline.model.GetBudgetRequest(farmId, budgetId)
    def farmId: FarmId
    def budgetId: BudgetId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getBudgetId: ZIO[Any, Nothing, BudgetId] = ZIO.succeed(budgetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetBudgetRequest
  ) extends zio.aws.deadline.model.GetBudgetRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val budgetId: BudgetId =
      zio.aws.deadline.model.primitives.BudgetId(impl.budgetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetBudgetRequest
  ): zio.aws.deadline.model.GetBudgetRequest.ReadOnly = new Wrapper(impl)
}
