package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  BudgetId,
  UpdatedBy,
  CreatedAt,
  Description,
  CreatedBy,
  ConsumedUsageLimit,
  UpdatedAt,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetBudgetResponse(
    budgetId: BudgetId,
    usageTrackingResource: zio.aws.deadline.model.UsageTrackingResource,
    status: zio.aws.deadline.model.BudgetStatus,
    displayName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    approximateDollarLimit: ConsumedUsageLimit,
    usages: zio.aws.deadline.model.ConsumedUsages,
    actions: Iterable[zio.aws.deadline.model.ResponseBudgetAction],
    schedule: zio.aws.deadline.model.BudgetSchedule,
    createdBy: CreatedBy,
    createdAt: CreatedAt,
    updatedBy: Optional[UpdatedBy] = Optional.Absent,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    queueStoppedAt: Optional[UpdatedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetBudgetResponse = {
    import GetBudgetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetBudgetResponse
      .builder()
      .budgetId(BudgetId.unwrap(budgetId): java.lang.String)
      .usageTrackingResource(usageTrackingResource.buildAwsValue())
      .status(status.unwrap)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .approximateDollarLimit(
        ConsumedUsageLimit.unwrap(approximateDollarLimit): java.lang.Float
      )
      .usages(usages.buildAwsValue())
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .schedule(schedule.buildAwsValue())
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        queueStoppedAt.map(value => UpdatedAt.unwrap(value): Instant)
      )(_.queueStoppedAt)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetBudgetResponse.ReadOnly =
    zio.aws.deadline.model.GetBudgetResponse.wrap(buildAwsValue())
}
object GetBudgetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetBudgetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetBudgetResponse =
      zio.aws.deadline.model.GetBudgetResponse(
        budgetId,
        usageTrackingResource.asEditable,
        status,
        displayName,
        description.map(value => value),
        approximateDollarLimit,
        usages.asEditable,
        actions.map { item =>
          item.asEditable
        },
        schedule.asEditable,
        createdBy,
        createdAt,
        updatedBy.map(value => value),
        updatedAt.map(value => value),
        queueStoppedAt.map(value => value)
      )
    def budgetId: BudgetId
    def usageTrackingResource
        : zio.aws.deadline.model.UsageTrackingResource.ReadOnly
    def status: zio.aws.deadline.model.BudgetStatus
    def displayName: ResourceName
    def description: Optional[Description]
    def approximateDollarLimit: ConsumedUsageLimit
    def usages: zio.aws.deadline.model.ConsumedUsages.ReadOnly
    def actions: List[zio.aws.deadline.model.ResponseBudgetAction.ReadOnly]
    def schedule: zio.aws.deadline.model.BudgetSchedule.ReadOnly
    def createdBy: CreatedBy
    def createdAt: CreatedAt
    def updatedBy: Optional[UpdatedBy]
    def updatedAt: Optional[UpdatedAt]
    def queueStoppedAt: Optional[UpdatedAt]
    def getBudgetId: ZIO[Any, Nothing, BudgetId] = ZIO.succeed(budgetId)
    def getUsageTrackingResource: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.UsageTrackingResource.ReadOnly
    ] = ZIO.succeed(usageTrackingResource)
    def getStatus: ZIO[Any, Nothing, zio.aws.deadline.model.BudgetStatus] =
      ZIO.succeed(status)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getApproximateDollarLimit: ZIO[Any, Nothing, ConsumedUsageLimit] =
      ZIO.succeed(approximateDollarLimit)
    def getUsages
        : ZIO[Any, Nothing, zio.aws.deadline.model.ConsumedUsages.ReadOnly] =
      ZIO.succeed(usages)
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.ResponseBudgetAction.ReadOnly
    ]] = ZIO.succeed(actions)
    def getSchedule
        : ZIO[Any, Nothing, zio.aws.deadline.model.BudgetSchedule.ReadOnly] =
      ZIO.succeed(schedule)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getQueueStoppedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("queueStoppedAt", queueStoppedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetBudgetResponse
  ) extends zio.aws.deadline.model.GetBudgetResponse.ReadOnly {
    override val budgetId: BudgetId =
      zio.aws.deadline.model.primitives.BudgetId(impl.budgetId())
    override val usageTrackingResource
        : zio.aws.deadline.model.UsageTrackingResource.ReadOnly =
      zio.aws.deadline.model.UsageTrackingResource
        .wrap(impl.usageTrackingResource())
    override val status: zio.aws.deadline.model.BudgetStatus =
      zio.aws.deadline.model.BudgetStatus.wrap(impl.status())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val approximateDollarLimit: ConsumedUsageLimit =
      zio.aws.deadline.model.primitives
        .ConsumedUsageLimit(impl.approximateDollarLimit())
    override val usages: zio.aws.deadline.model.ConsumedUsages.ReadOnly =
      zio.aws.deadline.model.ConsumedUsages.wrap(impl.usages())
    override val actions
        : List[zio.aws.deadline.model.ResponseBudgetAction.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.deadline.model.ResponseBudgetAction.wrap(item)
      }
      .toList
    override val schedule: zio.aws.deadline.model.BudgetSchedule.ReadOnly =
      zio.aws.deadline.model.BudgetSchedule.wrap(impl.schedule())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val queueStoppedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.queueStoppedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetBudgetResponse
  ): zio.aws.deadline.model.GetBudgetResponse.ReadOnly = new Wrapper(impl)
}
