package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.FarmId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFarmRequest(farmId: FarmId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetFarmRequest = {
    import GetFarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetFarmRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetFarmRequest.ReadOnly =
    zio.aws.deadline.model.GetFarmRequest.wrap(buildAwsValue())
}
object GetFarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetFarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetFarmRequest =
      zio.aws.deadline.model.GetFarmRequest(farmId)
    def farmId: FarmId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetFarmRequest
  ) extends zio.aws.deadline.model.GetFarmRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetFarmRequest
  ): zio.aws.deadline.model.GetFarmRequest.ReadOnly = new Wrapper(impl)
}
