package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  FarmId,
  UpdatedBy,
  CreatedAt,
  Description,
  CreatedBy,
  UpdatedAt,
  KmsKeyArn,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetFarmResponse(
    farmId: FarmId,
    displayName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    kmsKeyArn: KmsKeyArn,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetFarmResponse = {
    import GetFarmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetFarmResponse
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .kmsKeyArn(KmsKeyArn.unwrap(kmsKeyArn): java.lang.String)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetFarmResponse.ReadOnly =
    zio.aws.deadline.model.GetFarmResponse.wrap(buildAwsValue())
}
object GetFarmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetFarmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetFarmResponse =
      zio.aws.deadline.model.GetFarmResponse(
        farmId,
        displayName,
        description.map(value => value),
        kmsKeyArn,
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def farmId: FarmId
    def displayName: ResourceName
    def description: Optional[Description]
    def kmsKeyArn: KmsKeyArn
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyArn: ZIO[Any, Nothing, KmsKeyArn] = ZIO.succeed(kmsKeyArn)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetFarmResponse
  ) extends zio.aws.deadline.model.GetFarmResponse.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val kmsKeyArn: KmsKeyArn =
      zio.aws.deadline.model.primitives.KmsKeyArn(impl.kmsKeyArn())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetFarmResponse
  ): zio.aws.deadline.model.GetFarmResponse.ReadOnly = new Wrapper(impl)
}
