package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{FleetId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFleetRequest(farmId: FarmId, fleetId: FleetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetFleetRequest = {
    import GetFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetFleetRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetFleetRequest.ReadOnly =
    zio.aws.deadline.model.GetFleetRequest.wrap(buildAwsValue())
}
object GetFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetFleetRequest =
      zio.aws.deadline.model.GetFleetRequest(farmId, fleetId)
    def farmId: FarmId
    def fleetId: FleetId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetFleetRequest
  ) extends zio.aws.deadline.model.GetFleetRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetFleetRequest
  ): zio.aws.deadline.model.GetFleetRequest.ReadOnly = new Wrapper(impl)
}
