package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  FleetId,
  IamRoleArn,
  FarmId,
  UpdatedBy,
  CreatedAt,
  Description,
  CreatedBy,
  MinZeroMaxInteger,
  UpdatedAt,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetFleetResponse(
    fleetId: FleetId,
    farmId: FarmId,
    displayName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    status: zio.aws.deadline.model.FleetStatus,
    autoScalingStatus: Optional[zio.aws.deadline.model.AutoScalingStatus] =
      Optional.Absent,
    targetWorkerCount: Optional[zio.aws.deadline.model.primitives.Integer] =
      Optional.Absent,
    workerCount: zio.aws.deadline.model.primitives.Integer,
    minWorkerCount: MinZeroMaxInteger,
    maxWorkerCount: MinZeroMaxInteger,
    configuration: zio.aws.deadline.model.FleetConfiguration,
    capabilities: Optional[zio.aws.deadline.model.FleetCapabilities] =
      Optional.Absent,
    roleArn: IamRoleArn,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetFleetResponse = {
    import GetFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetFleetResponse
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .status(status.unwrap)
      .optionallyWith(autoScalingStatus.map(value => value.unwrap))(
        _.autoScalingStatus
      )
      .optionallyWith(targetWorkerCount.map(value => value: Integer))(
        _.targetWorkerCount
      )
      .workerCount(workerCount: Integer)
      .minWorkerCount(MinZeroMaxInteger.unwrap(minWorkerCount): Integer)
      .maxWorkerCount(MinZeroMaxInteger.unwrap(maxWorkerCount): Integer)
      .configuration(configuration.buildAwsValue())
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .roleArn(IamRoleArn.unwrap(roleArn): java.lang.String)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetFleetResponse.ReadOnly =
    zio.aws.deadline.model.GetFleetResponse.wrap(buildAwsValue())
}
object GetFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetFleetResponse =
      zio.aws.deadline.model.GetFleetResponse(
        fleetId,
        farmId,
        displayName,
        description.map(value => value),
        status,
        autoScalingStatus.map(value => value),
        targetWorkerCount.map(value => value),
        workerCount,
        minWorkerCount,
        maxWorkerCount,
        configuration.asEditable,
        capabilities.map(value => value.asEditable),
        roleArn,
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def fleetId: FleetId
    def farmId: FarmId
    def displayName: ResourceName
    def description: Optional[Description]
    def status: zio.aws.deadline.model.FleetStatus
    def autoScalingStatus: Optional[zio.aws.deadline.model.AutoScalingStatus]
    def targetWorkerCount: Optional[zio.aws.deadline.model.primitives.Integer]
    def workerCount: zio.aws.deadline.model.primitives.Integer
    def minWorkerCount: MinZeroMaxInteger
    def maxWorkerCount: MinZeroMaxInteger
    def configuration: zio.aws.deadline.model.FleetConfiguration.ReadOnly
    def capabilities
        : Optional[zio.aws.deadline.model.FleetCapabilities.ReadOnly]
    def roleArn: IamRoleArn
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, Nothing, zio.aws.deadline.model.FleetStatus] =
      ZIO.succeed(status)
    def getAutoScalingStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.AutoScalingStatus] =
      AwsError.unwrapOptionField("autoScalingStatus", autoScalingStatus)
    def getTargetWorkerCount
        : ZIO[Any, AwsError, zio.aws.deadline.model.primitives.Integer] =
      AwsError.unwrapOptionField("targetWorkerCount", targetWorkerCount)
    def getWorkerCount
        : ZIO[Any, Nothing, zio.aws.deadline.model.primitives.Integer] =
      ZIO.succeed(workerCount)
    def getMinWorkerCount: ZIO[Any, Nothing, MinZeroMaxInteger] =
      ZIO.succeed(minWorkerCount)
    def getMaxWorkerCount: ZIO[Any, Nothing, MinZeroMaxInteger] =
      ZIO.succeed(maxWorkerCount)
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.FleetConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
    def getCapabilities: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.FleetCapabilities.ReadOnly
    ] = AwsError.unwrapOptionField("capabilities", capabilities)
    def getRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(roleArn)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetFleetResponse
  ) extends zio.aws.deadline.model.GetFleetResponse.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val status: zio.aws.deadline.model.FleetStatus =
      zio.aws.deadline.model.FleetStatus.wrap(impl.status())
    override val autoScalingStatus
        : Optional[zio.aws.deadline.model.AutoScalingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingStatus())
        .map(value => zio.aws.deadline.model.AutoScalingStatus.wrap(value))
    override val targetWorkerCount
        : Optional[zio.aws.deadline.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetWorkerCount())
        .map(value => value: zio.aws.deadline.model.primitives.Integer)
    override val workerCount: zio.aws.deadline.model.primitives.Integer =
      impl.workerCount(): zio.aws.deadline.model.primitives.Integer
    override val minWorkerCount: MinZeroMaxInteger =
      zio.aws.deadline.model.primitives.MinZeroMaxInteger(impl.minWorkerCount())
    override val maxWorkerCount: MinZeroMaxInteger =
      zio.aws.deadline.model.primitives.MinZeroMaxInteger(impl.maxWorkerCount())
    override val configuration
        : zio.aws.deadline.model.FleetConfiguration.ReadOnly =
      zio.aws.deadline.model.FleetConfiguration.wrap(impl.configuration())
    override val capabilities
        : Optional[zio.aws.deadline.model.FleetCapabilities.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value => zio.aws.deadline.model.FleetCapabilities.wrap(value))
    override val roleArn: IamRoleArn =
      zio.aws.deadline.model.primitives.IamRoleArn(impl.roleArn())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetFleetResponse
  ): zio.aws.deadline.model.GetFleetResponse.ReadOnly = new Wrapper(impl)
}
