package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetJobEntityError(
    jobDetails: Optional[zio.aws.deadline.model.JobDetailsError] =
      Optional.Absent,
    jobAttachmentDetails: Optional[
      zio.aws.deadline.model.JobAttachmentDetailsError
    ] = Optional.Absent,
    stepDetails: Optional[zio.aws.deadline.model.StepDetailsError] =
      Optional.Absent,
    environmentDetails: Optional[
      zio.aws.deadline.model.EnvironmentDetailsError
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetJobEntityError = {
    import GetJobEntityError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetJobEntityError
      .builder()
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .optionallyWith(jobAttachmentDetails.map(value => value.buildAwsValue()))(
        _.jobAttachmentDetails
      )
      .optionallyWith(stepDetails.map(value => value.buildAwsValue()))(
        _.stepDetails
      )
      .optionallyWith(environmentDetails.map(value => value.buildAwsValue()))(
        _.environmentDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetJobEntityError.ReadOnly =
    zio.aws.deadline.model.GetJobEntityError.wrap(buildAwsValue())
}
object GetJobEntityError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetJobEntityError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetJobEntityError =
      zio.aws.deadline.model.GetJobEntityError(
        jobDetails.map(value => value.asEditable),
        jobAttachmentDetails.map(value => value.asEditable),
        stepDetails.map(value => value.asEditable),
        environmentDetails.map(value => value.asEditable)
      )
    def jobDetails: Optional[zio.aws.deadline.model.JobDetailsError.ReadOnly]
    def jobAttachmentDetails
        : Optional[zio.aws.deadline.model.JobAttachmentDetailsError.ReadOnly]
    def stepDetails: Optional[zio.aws.deadline.model.StepDetailsError.ReadOnly]
    def environmentDetails
        : Optional[zio.aws.deadline.model.EnvironmentDetailsError.ReadOnly]
    def getJobDetails
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobDetailsError.ReadOnly] =
      AwsError.unwrapOptionField("jobDetails", jobDetails)
    def getJobAttachmentDetails: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.JobAttachmentDetailsError.ReadOnly
    ] = AwsError.unwrapOptionField("jobAttachmentDetails", jobAttachmentDetails)
    def getStepDetails
        : ZIO[Any, AwsError, zio.aws.deadline.model.StepDetailsError.ReadOnly] =
      AwsError.unwrapOptionField("stepDetails", stepDetails)
    def getEnvironmentDetails: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.EnvironmentDetailsError.ReadOnly
    ] = AwsError.unwrapOptionField("environmentDetails", environmentDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetJobEntityError
  ) extends zio.aws.deadline.model.GetJobEntityError.ReadOnly {
    override val jobDetails
        : Optional[zio.aws.deadline.model.JobDetailsError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDetails())
        .map(value => zio.aws.deadline.model.JobDetailsError.wrap(value))
    override val jobAttachmentDetails
        : Optional[zio.aws.deadline.model.JobAttachmentDetailsError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobAttachmentDetails())
        .map(value =>
          zio.aws.deadline.model.JobAttachmentDetailsError.wrap(value)
        )
    override val stepDetails
        : Optional[zio.aws.deadline.model.StepDetailsError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepDetails())
        .map(value => zio.aws.deadline.model.StepDetailsError.wrap(value))
    override val environmentDetails
        : Optional[zio.aws.deadline.model.EnvironmentDetailsError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentDetails())
        .map(value =>
          zio.aws.deadline.model.EnvironmentDetailsError.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetJobEntityError
  ): zio.aws.deadline.model.GetJobEntityError.ReadOnly = new Wrapper(impl)
}
