package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{QueueId, JobId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetJobRequest(farmId: FarmId, jobId: JobId, queueId: QueueId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetJobRequest = {
    import GetJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetJobRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetJobRequest.ReadOnly =
    zio.aws.deadline.model.GetJobRequest.wrap(buildAwsValue())
}
object GetJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetJobRequest =
      zio.aws.deadline.model.GetJobRequest(farmId, jobId, queueId)
    def farmId: FarmId
    def jobId: JobId
    def queueId: QueueId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetJobRequest
  ) extends zio.aws.deadline.model.GetJobRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetJobRequest
  ): zio.aws.deadline.model.GetJobRequest.ReadOnly = new Wrapper(impl)
}
