package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  MaxFailedTasksCount,
  UpdatedBy,
  CreatedAt,
  JobPriority,
  MaxRetriesPerTask,
  EndedAt,
  JobName,
  StorageProfileId,
  JobId,
  CreatedBy,
  StartedAt,
  UpdatedAt,
  JobDescription
}
import scala.jdk.CollectionConverters._
final case class GetJobResponse(
    jobId: JobId,
    name: JobName,
    lifecycleStatus: zio.aws.deadline.model.JobLifecycleStatus,
    lifecycleStatusMessage: String,
    priority: JobPriority,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent,
    startedAt: Optional[StartedAt] = Optional.Absent,
    endedAt: Optional[EndedAt] = Optional.Absent,
    taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus] =
      Optional.Absent,
    targetTaskRunStatus: Optional[
      zio.aws.deadline.model.JobTargetTaskRunStatus
    ] = Optional.Absent,
    taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = Optional.Absent,
    storageProfileId: Optional[StorageProfileId] = Optional.Absent,
    maxFailedTasksCount: Optional[MaxFailedTasksCount] = Optional.Absent,
    maxRetriesPerTask: Optional[MaxRetriesPerTask] = Optional.Absent,
    parameters: Optional[Map[String, zio.aws.deadline.model.JobParameter]] =
      Optional.Absent,
    attachments: Optional[zio.aws.deadline.model.Attachments] = Optional.Absent,
    description: Optional[JobDescription] = Optional.Absent,
    sourceJobId: Optional[JobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetJobResponse = {
    import GetJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetJobResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .name(JobName.unwrap(name): java.lang.String)
      .lifecycleStatus(lifecycleStatus.unwrap)
      .lifecycleStatusMessage(lifecycleStatusMessage: java.lang.String)
      .priority(JobPriority.unwrap(priority): Integer)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .optionallyWith(startedAt.map(value => StartedAt.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(taskRunStatus.map(value => value.unwrap))(_.taskRunStatus)
      .optionallyWith(targetTaskRunStatus.map(value => value.unwrap))(
        _.targetTaskRunStatus
      )
      .optionallyWith(
        taskRunStatusCounts.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: Integer)
            })
            .asJava
        )
      )(_.taskRunStatusCountsWithStrings)
      .optionallyWith(
        storageProfileId.map(value =>
          StorageProfileId.unwrap(value): java.lang.String
        )
      )(_.storageProfileId)
      .optionallyWith(
        maxFailedTasksCount.map(value =>
          MaxFailedTasksCount.unwrap(value): Integer
        )
      )(_.maxFailedTasksCount)
      .optionallyWith(
        maxRetriesPerTask.map(value => MaxRetriesPerTask.unwrap(value): Integer)
      )(_.maxRetriesPerTask)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(attachments.map(value => value.buildAwsValue()))(
        _.attachments
      )
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        sourceJobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.sourceJobId)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetJobResponse.ReadOnly =
    zio.aws.deadline.model.GetJobResponse.wrap(buildAwsValue())
}
object GetJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetJobResponse =
      zio.aws.deadline.model.GetJobResponse(
        jobId,
        name,
        lifecycleStatus,
        lifecycleStatusMessage,
        priority,
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value),
        startedAt.map(value => value),
        endedAt.map(value => value),
        taskRunStatus.map(value => value),
        targetTaskRunStatus.map(value => value),
        taskRunStatusCounts.map(value => value),
        storageProfileId.map(value => value),
        maxFailedTasksCount.map(value => value),
        maxRetriesPerTask.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        attachments.map(value => value.asEditable),
        description.map(value => value),
        sourceJobId.map(value => value)
      )
    def jobId: JobId
    def name: JobName
    def lifecycleStatus: zio.aws.deadline.model.JobLifecycleStatus
    def lifecycleStatusMessage: String
    def priority: JobPriority
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def startedAt: Optional[StartedAt]
    def endedAt: Optional[EndedAt]
    def taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus]
    def targetTaskRunStatus
        : Optional[zio.aws.deadline.model.JobTargetTaskRunStatus]
    def taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]]
    def storageProfileId: Optional[StorageProfileId]
    def maxFailedTasksCount: Optional[MaxFailedTasksCount]
    def maxRetriesPerTask: Optional[MaxRetriesPerTask]
    def parameters
        : Optional[Map[String, zio.aws.deadline.model.JobParameter.ReadOnly]]
    def attachments: Optional[zio.aws.deadline.model.Attachments.ReadOnly]
    def description: Optional[JobDescription]
    def sourceJobId: Optional[JobId]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
    def getLifecycleStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.JobLifecycleStatus] =
      ZIO.succeed(lifecycleStatus)
    def getLifecycleStatusMessage: ZIO[Any, Nothing, String] =
      ZIO.succeed(lifecycleStatusMessage)
    def getPriority: ZIO[Any, Nothing, JobPriority] = ZIO.succeed(priority)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getTaskRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.TaskRunStatus] =
      AwsError.unwrapOptionField("taskRunStatus", taskRunStatus)
    def getTargetTaskRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobTargetTaskRunStatus] =
      AwsError.unwrapOptionField("targetTaskRunStatus", targetTaskRunStatus)
    def getTaskRunStatusCounts: ZIO[Any, AwsError, Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = AwsError.unwrapOptionField("taskRunStatusCounts", taskRunStatusCounts)
    def getStorageProfileId: ZIO[Any, AwsError, StorageProfileId] =
      AwsError.unwrapOptionField("storageProfileId", storageProfileId)
    def getMaxFailedTasksCount: ZIO[Any, AwsError, MaxFailedTasksCount] =
      AwsError.unwrapOptionField("maxFailedTasksCount", maxFailedTasksCount)
    def getMaxRetriesPerTask: ZIO[Any, AwsError, MaxRetriesPerTask] =
      AwsError.unwrapOptionField("maxRetriesPerTask", maxRetriesPerTask)
    def getParameters: ZIO[Any, AwsError, Map[
      String,
      zio.aws.deadline.model.JobParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getAttachments
        : ZIO[Any, AwsError, zio.aws.deadline.model.Attachments.ReadOnly] =
      AwsError.unwrapOptionField("attachments", attachments)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSourceJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("sourceJobId", sourceJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetJobResponse
  ) extends zio.aws.deadline.model.GetJobResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val name: JobName =
      zio.aws.deadline.model.primitives.JobName(impl.name())
    override val lifecycleStatus: zio.aws.deadline.model.JobLifecycleStatus =
      zio.aws.deadline.model.JobLifecycleStatus.wrap(impl.lifecycleStatus())
    override val lifecycleStatusMessage: String =
      impl.lifecycleStatusMessage(): String
    override val priority: JobPriority =
      zio.aws.deadline.model.primitives.JobPriority(impl.priority())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.deadline.model.primitives.StartedAt(value))
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskRunStatus())
        .map(value => zio.aws.deadline.model.TaskRunStatus.wrap(value))
    override val targetTaskRunStatus
        : Optional[zio.aws.deadline.model.JobTargetTaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetTaskRunStatus())
        .map(value => zio.aws.deadline.model.JobTargetTaskRunStatus.wrap(value))
    override val taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRunStatusCounts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.deadline.model.TaskRunStatus
              .wrap(key) -> (value: zio.aws.deadline.model.primitives.Integer)
          })
          .toMap
      )
    override val storageProfileId: Optional[StorageProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageProfileId())
        .map(value => zio.aws.deadline.model.primitives.StorageProfileId(value))
    override val maxFailedTasksCount: Optional[MaxFailedTasksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxFailedTasksCount())
        .map(value =>
          zio.aws.deadline.model.primitives.MaxFailedTasksCount(value)
        )
    override val maxRetriesPerTask: Optional[MaxRetriesPerTask] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRetriesPerTask())
        .map(value =>
          zio.aws.deadline.model.primitives.MaxRetriesPerTask(value)
        )
    override val parameters
        : Optional[Map[String, zio.aws.deadline.model.JobParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.deadline.model.JobParameter.wrap(value)
            })
            .toMap
        )
    override val attachments
        : Optional[zio.aws.deadline.model.Attachments.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value => zio.aws.deadline.model.Attachments.wrap(value))
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.JobDescription(value))
    override val sourceJobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceJobId())
      .map(value => zio.aws.deadline.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetJobResponse
  ): zio.aws.deadline.model.GetJobResponse.ReadOnly = new Wrapper(impl)
}
