package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.LicenseEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLicenseEndpointRequest(
    licenseEndpointId: LicenseEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest = {
    import GetLicenseEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest
      .builder()
      .licenseEndpointId(
        LicenseEndpointId.unwrap(licenseEndpointId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetLicenseEndpointRequest.ReadOnly =
    zio.aws.deadline.model.GetLicenseEndpointRequest.wrap(buildAwsValue())
}
object GetLicenseEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetLicenseEndpointRequest =
      zio.aws.deadline.model.GetLicenseEndpointRequest(licenseEndpointId)
    def licenseEndpointId: LicenseEndpointId
    def getLicenseEndpointId: ZIO[Any, Nothing, LicenseEndpointId] =
      ZIO.succeed(licenseEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest
  ) extends zio.aws.deadline.model.GetLicenseEndpointRequest.ReadOnly {
    override val licenseEndpointId: LicenseEndpointId =
      zio.aws.deadline.model.primitives
        .LicenseEndpointId(impl.licenseEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest
  ): zio.aws.deadline.model.GetLicenseEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
