package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  SubnetId,
  VpcId,
  DnsName,
  LicenseEndpointId,
  SecurityGroupId,
  StatusMessage
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLicenseEndpointResponse(
    licenseEndpointId: LicenseEndpointId,
    status: zio.aws.deadline.model.LicenseEndpointStatus,
    statusMessage: StatusMessage,
    vpcId: Optional[VpcId] = Optional.Absent,
    dnsName: Optional[DnsName] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse = {
    import GetLicenseEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse
      .builder()
      .licenseEndpointId(
        LicenseEndpointId.unwrap(licenseEndpointId): java.lang.String
      )
      .status(status.unwrap)
      .statusMessage(StatusMessage.unwrap(statusMessage): java.lang.String)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetLicenseEndpointResponse.ReadOnly =
    zio.aws.deadline.model.GetLicenseEndpointResponse.wrap(buildAwsValue())
}
object GetLicenseEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetLicenseEndpointResponse =
      zio.aws.deadline.model.GetLicenseEndpointResponse(
        licenseEndpointId,
        status,
        statusMessage,
        vpcId.map(value => value),
        dnsName.map(value => value),
        subnetIds.map(value => value),
        securityGroupIds.map(value => value)
      )
    def licenseEndpointId: LicenseEndpointId
    def status: zio.aws.deadline.model.LicenseEndpointStatus
    def statusMessage: StatusMessage
    def vpcId: Optional[VpcId]
    def dnsName: Optional[DnsName]
    def subnetIds: Optional[List[SubnetId]]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def getLicenseEndpointId: ZIO[Any, Nothing, LicenseEndpointId] =
      ZIO.succeed(licenseEndpointId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.LicenseEndpointStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, Nothing, StatusMessage] =
      ZIO.succeed(statusMessage)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse
  ) extends zio.aws.deadline.model.GetLicenseEndpointResponse.ReadOnly {
    override val licenseEndpointId: LicenseEndpointId =
      zio.aws.deadline.model.primitives
        .LicenseEndpointId(impl.licenseEndpointId())
    override val status: zio.aws.deadline.model.LicenseEndpointStatus =
      zio.aws.deadline.model.LicenseEndpointStatus.wrap(impl.status())
    override val statusMessage: StatusMessage =
      zio.aws.deadline.model.primitives.StatusMessage(impl.statusMessage())
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.deadline.model.primitives.VpcId(value))
    override val dnsName: Optional[DnsName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.deadline.model.primitives.DnsName(value))
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse
  ): zio.aws.deadline.model.GetLicenseEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
