package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.MonitorId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMonitorRequest(monitorId: MonitorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetMonitorRequest = {
    import GetMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetMonitorRequest
      .builder()
      .monitorId(MonitorId.unwrap(monitorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetMonitorRequest.ReadOnly =
    zio.aws.deadline.model.GetMonitorRequest.wrap(buildAwsValue())
}
object GetMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetMonitorRequest =
      zio.aws.deadline.model.GetMonitorRequest(monitorId)
    def monitorId: MonitorId
    def getMonitorId: ZIO[Any, Nothing, MonitorId] = ZIO.succeed(monitorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetMonitorRequest
  ) extends zio.aws.deadline.model.GetMonitorRequest.ReadOnly {
    override val monitorId: MonitorId =
      zio.aws.deadline.model.primitives.MonitorId(impl.monitorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetMonitorRequest
  ): zio.aws.deadline.model.GetMonitorRequest.ReadOnly = new Wrapper(impl)
}
