package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueEnvironmentId,
  UpdatedBy,
  CreatedAt,
  Priority,
  EnvironmentName,
  CreatedBy,
  EnvironmentTemplate,
  UpdatedAt
}
import scala.jdk.CollectionConverters._
final case class GetQueueEnvironmentResponse(
    queueEnvironmentId: QueueEnvironmentId,
    name: EnvironmentName,
    priority: Priority,
    templateType: zio.aws.deadline.model.EnvironmentTemplateType,
    template: EnvironmentTemplate,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse = {
    import GetQueueEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse
      .builder()
      .queueEnvironmentId(
        QueueEnvironmentId.unwrap(queueEnvironmentId): java.lang.String
      )
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .priority(Priority.unwrap(priority): Integer)
      .templateType(templateType.unwrap)
      .template(EnvironmentTemplate.unwrap(template): java.lang.String)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetQueueEnvironmentResponse.ReadOnly =
    zio.aws.deadline.model.GetQueueEnvironmentResponse.wrap(buildAwsValue())
}
object GetQueueEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetQueueEnvironmentResponse =
      zio.aws.deadline.model.GetQueueEnvironmentResponse(
        queueEnvironmentId,
        name,
        priority,
        templateType,
        template,
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def queueEnvironmentId: QueueEnvironmentId
    def name: EnvironmentName
    def priority: Priority
    def templateType: zio.aws.deadline.model.EnvironmentTemplateType
    def template: EnvironmentTemplate
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getQueueEnvironmentId: ZIO[Any, Nothing, QueueEnvironmentId] =
      ZIO.succeed(queueEnvironmentId)
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.deadline.model.EnvironmentTemplateType] =
      ZIO.succeed(templateType)
    def getTemplate: ZIO[Any, Nothing, EnvironmentTemplate] =
      ZIO.succeed(template)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse
  ) extends zio.aws.deadline.model.GetQueueEnvironmentResponse.ReadOnly {
    override val queueEnvironmentId: QueueEnvironmentId =
      zio.aws.deadline.model.primitives
        .QueueEnvironmentId(impl.queueEnvironmentId())
    override val name: EnvironmentName =
      zio.aws.deadline.model.primitives.EnvironmentName(impl.name())
    override val priority: Priority =
      zio.aws.deadline.model.primitives.Priority(impl.priority())
    override val templateType: zio.aws.deadline.model.EnvironmentTemplateType =
      zio.aws.deadline.model.EnvironmentTemplateType.wrap(impl.templateType())
    override val template: EnvironmentTemplate =
      zio.aws.deadline.model.primitives.EnvironmentTemplate(impl.template())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse
  ): zio.aws.deadline.model.GetQueueEnvironmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
