package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  QueueId,
  FleetId,
  UpdatedBy,
  CreatedAt,
  CreatedBy,
  UpdatedAt
}
import scala.jdk.CollectionConverters._
final case class GetQueueFleetAssociationResponse(
    queueId: QueueId,
    fleetId: FleetId,
    status: zio.aws.deadline.model.QueueFleetAssociationStatus,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse = {
    import GetQueueFleetAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse
      .builder()
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .status(status.unwrap)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.GetQueueFleetAssociationResponse.ReadOnly =
    zio.aws.deadline.model.GetQueueFleetAssociationResponse
      .wrap(buildAwsValue())
}
object GetQueueFleetAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetQueueFleetAssociationResponse =
      zio.aws.deadline.model.GetQueueFleetAssociationResponse(
        queueId,
        fleetId,
        status,
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def queueId: QueueId
    def fleetId: FleetId
    def status: zio.aws.deadline.model.QueueFleetAssociationStatus
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.QueueFleetAssociationStatus
    ] = ZIO.succeed(status)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse
  ) extends zio.aws.deadline.model.GetQueueFleetAssociationResponse.ReadOnly {
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val status: zio.aws.deadline.model.QueueFleetAssociationStatus =
      zio.aws.deadline.model.QueueFleetAssociationStatus.wrap(impl.status())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse
  ): zio.aws.deadline.model.GetQueueFleetAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
