package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  QueueId,
  IamRoleArn,
  FarmId,
  UpdatedBy,
  CreatedAt,
  FileSystemLocationName,
  StorageProfileId,
  Description,
  CreatedBy,
  UpdatedAt,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetQueueResponse(
    queueId: QueueId,
    displayName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    farmId: FarmId,
    status: zio.aws.deadline.model.QueueStatus,
    defaultBudgetAction: zio.aws.deadline.model.DefaultQueueBudgetAction,
    blockedReason: Optional[zio.aws.deadline.model.QueueBlockedReason] =
      Optional.Absent,
    jobAttachmentSettings: Optional[
      zio.aws.deadline.model.JobAttachmentSettings
    ] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    requiredFileSystemLocationNames: Optional[
      Iterable[FileSystemLocationName]
    ] = Optional.Absent,
    allowedStorageProfileIds: Optional[Iterable[StorageProfileId]] =
      Optional.Absent,
    jobRunAsUser: Optional[zio.aws.deadline.model.JobRunAsUser] =
      Optional.Absent,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetQueueResponse = {
    import GetQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetQueueResponse
      .builder()
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .status(status.unwrap)
      .defaultBudgetAction(defaultBudgetAction.unwrap)
      .optionallyWith(blockedReason.map(value => value.unwrap))(_.blockedReason)
      .optionallyWith(
        jobAttachmentSettings.map(value => value.buildAwsValue())
      )(_.jobAttachmentSettings)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        requiredFileSystemLocationNames.map(value =>
          value.map { item =>
            FileSystemLocationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiredFileSystemLocationNames)
      .optionallyWith(
        allowedStorageProfileIds.map(value =>
          value.map { item =>
            StorageProfileId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedStorageProfileIds)
      .optionallyWith(jobRunAsUser.map(value => value.buildAwsValue()))(
        _.jobRunAsUser
      )
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetQueueResponse.ReadOnly =
    zio.aws.deadline.model.GetQueueResponse.wrap(buildAwsValue())
}
object GetQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetQueueResponse =
      zio.aws.deadline.model.GetQueueResponse(
        queueId,
        displayName,
        description.map(value => value),
        farmId,
        status,
        defaultBudgetAction,
        blockedReason.map(value => value),
        jobAttachmentSettings.map(value => value.asEditable),
        roleArn.map(value => value),
        requiredFileSystemLocationNames.map(value => value),
        allowedStorageProfileIds.map(value => value),
        jobRunAsUser.map(value => value.asEditable),
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def queueId: QueueId
    def displayName: ResourceName
    def description: Optional[Description]
    def farmId: FarmId
    def status: zio.aws.deadline.model.QueueStatus
    def defaultBudgetAction: zio.aws.deadline.model.DefaultQueueBudgetAction
    def blockedReason: Optional[zio.aws.deadline.model.QueueBlockedReason]
    def jobAttachmentSettings
        : Optional[zio.aws.deadline.model.JobAttachmentSettings.ReadOnly]
    def roleArn: Optional[IamRoleArn]
    def requiredFileSystemLocationNames: Optional[List[FileSystemLocationName]]
    def allowedStorageProfileIds: Optional[List[StorageProfileId]]
    def jobRunAsUser: Optional[zio.aws.deadline.model.JobRunAsUser.ReadOnly]
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getStatus: ZIO[Any, Nothing, zio.aws.deadline.model.QueueStatus] =
      ZIO.succeed(status)
    def getDefaultBudgetAction
        : ZIO[Any, Nothing, zio.aws.deadline.model.DefaultQueueBudgetAction] =
      ZIO.succeed(defaultBudgetAction)
    def getBlockedReason
        : ZIO[Any, AwsError, zio.aws.deadline.model.QueueBlockedReason] =
      AwsError.unwrapOptionField("blockedReason", blockedReason)
    def getJobAttachmentSettings: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.JobAttachmentSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("jobAttachmentSettings", jobAttachmentSettings)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRequiredFileSystemLocationNames
        : ZIO[Any, AwsError, List[FileSystemLocationName]] =
      AwsError.unwrapOptionField(
        "requiredFileSystemLocationNames",
        requiredFileSystemLocationNames
      )
    def getAllowedStorageProfileIds
        : ZIO[Any, AwsError, List[StorageProfileId]] = AwsError
      .unwrapOptionField("allowedStorageProfileIds", allowedStorageProfileIds)
    def getJobRunAsUser
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobRunAsUser.ReadOnly] =
      AwsError.unwrapOptionField("jobRunAsUser", jobRunAsUser)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetQueueResponse
  ) extends zio.aws.deadline.model.GetQueueResponse.ReadOnly {
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val status: zio.aws.deadline.model.QueueStatus =
      zio.aws.deadline.model.QueueStatus.wrap(impl.status())
    override val defaultBudgetAction
        : zio.aws.deadline.model.DefaultQueueBudgetAction =
      zio.aws.deadline.model.DefaultQueueBudgetAction
        .wrap(impl.defaultBudgetAction())
    override val blockedReason
        : Optional[zio.aws.deadline.model.QueueBlockedReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockedReason())
        .map(value => zio.aws.deadline.model.QueueBlockedReason.wrap(value))
    override val jobAttachmentSettings
        : Optional[zio.aws.deadline.model.JobAttachmentSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobAttachmentSettings())
        .map(value => zio.aws.deadline.model.JobAttachmentSettings.wrap(value))
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.deadline.model.primitives.IamRoleArn(value))
    override val requiredFileSystemLocationNames
        : Optional[List[FileSystemLocationName]] = zio.aws.core.internal
      .optionalFromNullable(impl.requiredFileSystemLocationNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.FileSystemLocationName(item)
        }.toList
      )
    override val allowedStorageProfileIds: Optional[List[StorageProfileId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedStorageProfileIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.StorageProfileId(item)
          }.toList
        )
    override val jobRunAsUser
        : Optional[zio.aws.deadline.model.JobRunAsUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobRunAsUser())
        .map(value => zio.aws.deadline.model.JobRunAsUser.wrap(value))
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetQueueResponse
  ): zio.aws.deadline.model.GetQueueResponse.ReadOnly = new Wrapper(impl)
}
