package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  SessionActionId,
  JobId,
  QueueId,
  FarmId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSessionActionRequest(
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    sessionActionId: SessionActionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetSessionActionRequest = {
    import GetSessionActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetSessionActionRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .sessionActionId(
        SessionActionId.unwrap(sessionActionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetSessionActionRequest.ReadOnly =
    zio.aws.deadline.model.GetSessionActionRequest.wrap(buildAwsValue())
}
object GetSessionActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetSessionActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetSessionActionRequest =
      zio.aws.deadline.model.GetSessionActionRequest(
        farmId,
        queueId,
        jobId,
        sessionActionId
      )
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def sessionActionId: SessionActionId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getSessionActionId: ZIO[Any, Nothing, SessionActionId] =
      ZIO.succeed(sessionActionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionActionRequest
  ) extends zio.aws.deadline.model.GetSessionActionRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val sessionActionId: SessionActionId =
      zio.aws.deadline.model.primitives.SessionActionId(impl.sessionActionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionActionRequest
  ): zio.aws.deadline.model.GetSessionActionRequest.ReadOnly = new Wrapper(impl)
}
