package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  Timestamp,
  EndedAt,
  SessionActionProgressPercent,
  StartedAt,
  ProcessExitCode,
  SessionId,
  SessionActionProgressMessage,
  SessionActionId
}
import scala.jdk.CollectionConverters._
final case class GetSessionActionResponse(
    sessionActionId: SessionActionId,
    status: zio.aws.deadline.model.SessionActionStatus,
    startedAt: Optional[StartedAt] = Optional.Absent,
    endedAt: Optional[EndedAt] = Optional.Absent,
    workerUpdatedAt: Optional[Timestamp] = Optional.Absent,
    progressPercent: Optional[SessionActionProgressPercent] = Optional.Absent,
    sessionId: SessionId,
    processExitCode: Optional[ProcessExitCode] = Optional.Absent,
    progressMessage: Optional[SessionActionProgressMessage] = Optional.Absent,
    definition: zio.aws.deadline.model.SessionActionDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetSessionActionResponse = {
    import GetSessionActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetSessionActionResponse
      .builder()
      .sessionActionId(
        SessionActionId.unwrap(sessionActionId): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(startedAt.map(value => StartedAt.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(
        workerUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.workerUpdatedAt)
      .optionallyWith(
        progressPercent.map(value =>
          SessionActionProgressPercent.unwrap(value): java.lang.Float
        )
      )(_.progressPercent)
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .optionallyWith(
        processExitCode.map(value => ProcessExitCode.unwrap(value): Integer)
      )(_.processExitCode)
      .optionallyWith(
        progressMessage.map(value =>
          SessionActionProgressMessage.unwrap(value): java.lang.String
        )
      )(_.progressMessage)
      .definition(definition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetSessionActionResponse.ReadOnly =
    zio.aws.deadline.model.GetSessionActionResponse.wrap(buildAwsValue())
}
object GetSessionActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetSessionActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetSessionActionResponse =
      zio.aws.deadline.model.GetSessionActionResponse(
        sessionActionId,
        status,
        startedAt.map(value => value),
        endedAt.map(value => value),
        workerUpdatedAt.map(value => value),
        progressPercent.map(value => value),
        sessionId,
        processExitCode.map(value => value),
        progressMessage.map(value => value),
        definition.asEditable
      )
    def sessionActionId: SessionActionId
    def status: zio.aws.deadline.model.SessionActionStatus
    def startedAt: Optional[StartedAt]
    def endedAt: Optional[EndedAt]
    def workerUpdatedAt: Optional[Timestamp]
    def progressPercent: Optional[SessionActionProgressPercent]
    def sessionId: SessionId
    def processExitCode: Optional[ProcessExitCode]
    def progressMessage: Optional[SessionActionProgressMessage]
    def definition: zio.aws.deadline.model.SessionActionDefinition.ReadOnly
    def getSessionActionId: ZIO[Any, Nothing, SessionActionId] =
      ZIO.succeed(sessionActionId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.SessionActionStatus] =
      ZIO.succeed(status)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getWorkerUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("workerUpdatedAt", workerUpdatedAt)
    def getProgressPercent: ZIO[Any, AwsError, SessionActionProgressPercent] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getProcessExitCode: ZIO[Any, AwsError, ProcessExitCode] =
      AwsError.unwrapOptionField("processExitCode", processExitCode)
    def getProgressMessage: ZIO[Any, AwsError, SessionActionProgressMessage] =
      AwsError.unwrapOptionField("progressMessage", progressMessage)
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.SessionActionDefinition.ReadOnly
    ] = ZIO.succeed(definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionActionResponse
  ) extends zio.aws.deadline.model.GetSessionActionResponse.ReadOnly {
    override val sessionActionId: SessionActionId =
      zio.aws.deadline.model.primitives.SessionActionId(impl.sessionActionId())
    override val status: zio.aws.deadline.model.SessionActionStatus =
      zio.aws.deadline.model.SessionActionStatus.wrap(impl.status())
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.deadline.model.primitives.StartedAt(value))
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val workerUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.workerUpdatedAt())
      .map(value => zio.aws.deadline.model.primitives.Timestamp(value))
    override val progressPercent: Optional[SessionActionProgressPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressPercent())
        .map(value =>
          zio.aws.deadline.model.primitives.SessionActionProgressPercent(value)
        )
    override val sessionId: SessionId =
      zio.aws.deadline.model.primitives.SessionId(impl.sessionId())
    override val processExitCode: Optional[ProcessExitCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processExitCode())
        .map(value => zio.aws.deadline.model.primitives.ProcessExitCode(value))
    override val progressMessage: Optional[SessionActionProgressMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressMessage())
        .map(value =>
          zio.aws.deadline.model.primitives.SessionActionProgressMessage(value)
        )
    override val definition
        : zio.aws.deadline.model.SessionActionDefinition.ReadOnly =
      zio.aws.deadline.model.SessionActionDefinition.wrap(impl.definition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionActionResponse
  ): zio.aws.deadline.model.GetSessionActionResponse.ReadOnly = new Wrapper(
    impl
  )
}
