package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{SessionId, JobId, QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSessionRequest(
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    sessionId: SessionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetSessionRequest = {
    import GetSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetSessionRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetSessionRequest.ReadOnly =
    zio.aws.deadline.model.GetSessionRequest.wrap(buildAwsValue())
}
object GetSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetSessionRequest =
      zio.aws.deadline.model.GetSessionRequest(
        farmId,
        queueId,
        jobId,
        sessionId
      )
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def sessionId: SessionId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionRequest
  ) extends zio.aws.deadline.model.GetSessionRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val sessionId: SessionId =
      zio.aws.deadline.model.primitives.SessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionRequest
  ): zio.aws.deadline.model.GetSessionRequest.ReadOnly = new Wrapper(impl)
}
