package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{MaxResults, AggregationId, FarmId}
import scala.jdk.CollectionConverters._
final case class GetSessionsStatisticsAggregationRequest(
    farmId: FarmId,
    aggregationId: AggregationId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest = {
    import GetSessionsStatisticsAggregationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .aggregationId(AggregationId.unwrap(aggregationId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest.ReadOnly =
    zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest
      .wrap(buildAwsValue())
}
object GetSessionsStatisticsAggregationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest =
      zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest(
        farmId,
        aggregationId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def farmId: FarmId
    def aggregationId: AggregationId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getAggregationId: ZIO[Any, Nothing, AggregationId] =
      ZIO.succeed(aggregationId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest
  ) extends zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val aggregationId: AggregationId =
      zio.aws.deadline.model.primitives.AggregationId(impl.aggregationId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest
  ): zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest.ReadOnly =
    new Wrapper(impl)
}
