package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSessionsStatisticsAggregationResponse(
    statistics: Optional[Iterable[zio.aws.deadline.model.Statistics]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    status: zio.aws.deadline.model.SessionsStatisticsAggregationStatus,
    statusMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse = {
    import GetSessionsStatisticsAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse
      .builder()
      .optionallyWith(
        statistics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statistics)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .status(status.unwrap)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.ReadOnly =
    zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse
      .wrap(buildAwsValue())
}
object GetSessionsStatisticsAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse =
      zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse(
        statistics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        status,
        statusMessage.map(value => value)
      )
    def statistics: Optional[List[zio.aws.deadline.model.Statistics.ReadOnly]]
    def nextToken: Optional[String]
    def status: zio.aws.deadline.model.SessionsStatisticsAggregationStatus
    def statusMessage: Optional[String]
    def getStatistics
        : ZIO[Any, AwsError, List[zio.aws.deadline.model.Statistics.ReadOnly]] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.SessionsStatisticsAggregationStatus
    ] = ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse
  ) extends zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.ReadOnly {
    override val statistics
        : Optional[List[zio.aws.deadline.model.Statistics.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.Statistics.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val status
        : zio.aws.deadline.model.SessionsStatisticsAggregationStatus =
      zio.aws.deadline.model.SessionsStatisticsAggregationStatus
        .wrap(impl.status())
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse
  ): zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
