package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StepId, JobId, QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStepRequest(
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    stepId: StepId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetStepRequest = {
    import GetStepRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetStepRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetStepRequest.ReadOnly =
    zio.aws.deadline.model.GetStepRequest.wrap(buildAwsValue())
}
object GetStepRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetStepRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetStepRequest =
      zio.aws.deadline.model.GetStepRequest(farmId, queueId, jobId, stepId)
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def stepId: StepId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetStepRequest
  ) extends zio.aws.deadline.model.GetStepRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetStepRequest
  ): zio.aws.deadline.model.GetStepRequest.ReadOnly = new Wrapper(impl)
}
