package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StorageProfileId, QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStorageProfileForQueueRequest(
    farmId: FarmId,
    queueId: QueueId,
    storageProfileId: StorageProfileId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest = {
    import GetStorageProfileForQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .storageProfileId(
        StorageProfileId.unwrap(storageProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.GetStorageProfileForQueueRequest.ReadOnly =
    zio.aws.deadline.model.GetStorageProfileForQueueRequest
      .wrap(buildAwsValue())
}
object GetStorageProfileForQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetStorageProfileForQueueRequest =
      zio.aws.deadline.model
        .GetStorageProfileForQueueRequest(farmId, queueId, storageProfileId)
    def farmId: FarmId
    def queueId: QueueId
    def storageProfileId: StorageProfileId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getStorageProfileId: ZIO[Any, Nothing, StorageProfileId] =
      ZIO.succeed(storageProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest
  ) extends zio.aws.deadline.model.GetStorageProfileForQueueRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val storageProfileId: StorageProfileId =
      zio.aws.deadline.model.primitives
        .StorageProfileId(impl.storageProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest
  ): zio.aws.deadline.model.GetStorageProfileForQueueRequest.ReadOnly =
    new Wrapper(impl)
}
