package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{ResourceName, StorageProfileId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStorageProfileForQueueResponse(
    storageProfileId: StorageProfileId,
    displayName: ResourceName,
    osFamily: zio.aws.deadline.model.StorageProfileOperatingSystemFamily,
    fileSystemLocations: Optional[
      Iterable[zio.aws.deadline.model.FileSystemLocation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse = {
    import GetStorageProfileForQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse
      .builder()
      .storageProfileId(
        StorageProfileId.unwrap(storageProfileId): java.lang.String
      )
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .osFamily(osFamily.unwrap)
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.GetStorageProfileForQueueResponse.ReadOnly =
    zio.aws.deadline.model.GetStorageProfileForQueueResponse
      .wrap(buildAwsValue())
}
object GetStorageProfileForQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetStorageProfileForQueueResponse =
      zio.aws.deadline.model.GetStorageProfileForQueueResponse(
        storageProfileId,
        displayName,
        osFamily,
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storageProfileId: StorageProfileId
    def displayName: ResourceName
    def osFamily: zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    def fileSystemLocations
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]]
    def getStorageProfileId: ZIO[Any, Nothing, StorageProfileId] =
      ZIO.succeed(storageProfileId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getOsFamily: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    ] = ZIO.succeed(osFamily)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse
  ) extends zio.aws.deadline.model.GetStorageProfileForQueueResponse.ReadOnly {
    override val storageProfileId: StorageProfileId =
      zio.aws.deadline.model.primitives
        .StorageProfileId(impl.storageProfileId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val osFamily
        : zio.aws.deadline.model.StorageProfileOperatingSystemFamily =
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
        .wrap(impl.osFamily())
    override val fileSystemLocations
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.FileSystemLocation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse
  ): zio.aws.deadline.model.GetStorageProfileForQueueResponse.ReadOnly =
    new Wrapper(impl)
}
