package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  UpdatedBy,
  CreatedAt,
  StorageProfileId,
  CreatedBy,
  UpdatedAt,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetStorageProfileResponse(
    storageProfileId: StorageProfileId,
    displayName: ResourceName,
    osFamily: zio.aws.deadline.model.StorageProfileOperatingSystemFamily,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent,
    fileSystemLocations: Optional[
      Iterable[zio.aws.deadline.model.FileSystemLocation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse = {
    import GetStorageProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse
      .builder()
      .storageProfileId(
        StorageProfileId.unwrap(storageProfileId): java.lang.String
      )
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .osFamily(osFamily.unwrap)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetStorageProfileResponse.ReadOnly =
    zio.aws.deadline.model.GetStorageProfileResponse.wrap(buildAwsValue())
}
object GetStorageProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetStorageProfileResponse =
      zio.aws.deadline.model.GetStorageProfileResponse(
        storageProfileId,
        displayName,
        osFamily,
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value),
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storageProfileId: StorageProfileId
    def displayName: ResourceName
    def osFamily: zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def fileSystemLocations
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]]
    def getStorageProfileId: ZIO[Any, Nothing, StorageProfileId] =
      ZIO.succeed(storageProfileId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getOsFamily: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    ] = ZIO.succeed(osFamily)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse
  ) extends zio.aws.deadline.model.GetStorageProfileResponse.ReadOnly {
    override val storageProfileId: StorageProfileId =
      zio.aws.deadline.model.primitives
        .StorageProfileId(impl.storageProfileId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val osFamily
        : zio.aws.deadline.model.StorageProfileOperatingSystemFamily =
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
        .wrap(impl.osFamily())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
    override val fileSystemLocations
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.FileSystemLocation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse
  ): zio.aws.deadline.model.GetStorageProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
