package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  QueueId,
  FarmId,
  StepId,
  JobId,
  TaskId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetTaskRequest(
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    stepId: StepId,
    taskId: TaskId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetTaskRequest = {
    import GetTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetTaskRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetTaskRequest.ReadOnly =
    zio.aws.deadline.model.GetTaskRequest.wrap(buildAwsValue())
}
object GetTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetTaskRequest =
      zio.aws.deadline.model.GetTaskRequest(
        farmId,
        queueId,
        jobId,
        stepId,
        taskId
      )
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def stepId: StepId
    def taskId: TaskId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetTaskRequest
  ) extends zio.aws.deadline.model.GetTaskRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val taskId: TaskId =
      zio.aws.deadline.model.primitives.TaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetTaskRequest
  ): zio.aws.deadline.model.GetTaskRequest.ReadOnly = new Wrapper(impl)
}
