package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  UpdatedBy,
  CreatedAt,
  EndedAt,
  CreatedBy,
  TaskRetryCount,
  StartedAt,
  UpdatedAt,
  SessionActionId,
  TaskId
}
import scala.jdk.CollectionConverters._
final case class GetTaskResponse(
    taskId: TaskId,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    runStatus: zio.aws.deadline.model.TaskRunStatus,
    targetRunStatus: Optional[zio.aws.deadline.model.TaskTargetRunStatus] =
      Optional.Absent,
    failureRetryCount: Optional[TaskRetryCount] = Optional.Absent,
    parameters: Optional[
      Map[String, zio.aws.deadline.model.TaskParameterValue]
    ] = Optional.Absent,
    startedAt: Optional[StartedAt] = Optional.Absent,
    endedAt: Optional[EndedAt] = Optional.Absent,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent,
    latestSessionActionId: Optional[SessionActionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetTaskResponse = {
    import GetTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetTaskResponse
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .runStatus(runStatus.unwrap)
      .optionallyWith(targetRunStatus.map(value => value.unwrap))(
        _.targetRunStatus
      )
      .optionallyWith(
        failureRetryCount.map(value => TaskRetryCount.unwrap(value): Integer)
      )(_.failureRetryCount)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(startedAt.map(value => StartedAt.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .optionallyWith(
        latestSessionActionId.map(value =>
          SessionActionId.unwrap(value): java.lang.String
        )
      )(_.latestSessionActionId)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetTaskResponse.ReadOnly =
    zio.aws.deadline.model.GetTaskResponse.wrap(buildAwsValue())
}
object GetTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetTaskResponse =
      zio.aws.deadline.model.GetTaskResponse(
        taskId,
        createdAt,
        createdBy,
        runStatus,
        targetRunStatus.map(value => value),
        failureRetryCount.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        startedAt.map(value => value),
        endedAt.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value),
        latestSessionActionId.map(value => value)
      )
    def taskId: TaskId
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def runStatus: zio.aws.deadline.model.TaskRunStatus
    def targetRunStatus: Optional[zio.aws.deadline.model.TaskTargetRunStatus]
    def failureRetryCount: Optional[TaskRetryCount]
    def parameters: Optional[
      Map[String, zio.aws.deadline.model.TaskParameterValue.ReadOnly]
    ]
    def startedAt: Optional[StartedAt]
    def endedAt: Optional[EndedAt]
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def latestSessionActionId: Optional[SessionActionId]
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getRunStatus: ZIO[Any, Nothing, zio.aws.deadline.model.TaskRunStatus] =
      ZIO.succeed(runStatus)
    def getTargetRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.TaskTargetRunStatus] =
      AwsError.unwrapOptionField("targetRunStatus", targetRunStatus)
    def getFailureRetryCount: ZIO[Any, AwsError, TaskRetryCount] =
      AwsError.unwrapOptionField("failureRetryCount", failureRetryCount)
    def getParameters: ZIO[Any, AwsError, Map[
      String,
      zio.aws.deadline.model.TaskParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getLatestSessionActionId: ZIO[Any, AwsError, SessionActionId] =
      AwsError.unwrapOptionField("latestSessionActionId", latestSessionActionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetTaskResponse
  ) extends zio.aws.deadline.model.GetTaskResponse.ReadOnly {
    override val taskId: TaskId =
      zio.aws.deadline.model.primitives.TaskId(impl.taskId())
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val runStatus: zio.aws.deadline.model.TaskRunStatus =
      zio.aws.deadline.model.TaskRunStatus.wrap(impl.runStatus())
    override val targetRunStatus
        : Optional[zio.aws.deadline.model.TaskTargetRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetRunStatus())
        .map(value => zio.aws.deadline.model.TaskTargetRunStatus.wrap(value))
    override val failureRetryCount: Optional[TaskRetryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureRetryCount())
        .map(value => zio.aws.deadline.model.primitives.TaskRetryCount(value))
    override val parameters: Optional[
      Map[String, zio.aws.deadline.model.TaskParameterValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.deadline.model.TaskParameterValue
              .wrap(value)
          })
          .toMap
      )
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.deadline.model.primitives.StartedAt(value))
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
    override val latestSessionActionId: Optional[SessionActionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestSessionActionId())
        .map(value => zio.aws.deadline.model.primitives.SessionActionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetTaskResponse
  ): zio.aws.deadline.model.GetTaskResponse.ReadOnly = new Wrapper(impl)
}
