package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{WorkerId, FleetId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWorkerRequest(
    farmId: FarmId,
    fleetId: FleetId,
    workerId: WorkerId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.GetWorkerRequest = {
    import GetWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.GetWorkerRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .workerId(WorkerId.unwrap(workerId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.GetWorkerRequest.ReadOnly =
    zio.aws.deadline.model.GetWorkerRequest.wrap(buildAwsValue())
}
object GetWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.GetWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.GetWorkerRequest =
      zio.aws.deadline.model.GetWorkerRequest(farmId, fleetId, workerId)
    def farmId: FarmId
    def fleetId: FleetId
    def workerId: WorkerId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getWorkerId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(workerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.GetWorkerRequest
  ) extends zio.aws.deadline.model.GetWorkerRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val workerId: WorkerId =
      zio.aws.deadline.model.primitives.WorkerId(impl.workerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.GetWorkerRequest
  ): zio.aws.deadline.model.GetWorkerRequest.ReadOnly = new Wrapper(impl)
}
