package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.HostName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HostPropertiesRequest(
    ipAddresses: Optional[zio.aws.deadline.model.IpAddresses] = Optional.Absent,
    hostName: Optional[HostName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.HostPropertiesRequest = {
    import HostPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.HostPropertiesRequest
      .builder()
      .optionallyWith(ipAddresses.map(value => value.buildAwsValue()))(
        _.ipAddresses
      )
      .optionallyWith(
        hostName.map(value => HostName.unwrap(value): java.lang.String)
      )(_.hostName)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.HostPropertiesRequest.ReadOnly =
    zio.aws.deadline.model.HostPropertiesRequest.wrap(buildAwsValue())
}
object HostPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.HostPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.HostPropertiesRequest =
      zio.aws.deadline.model.HostPropertiesRequest(
        ipAddresses.map(value => value.asEditable),
        hostName.map(value => value)
      )
    def ipAddresses: Optional[zio.aws.deadline.model.IpAddresses.ReadOnly]
    def hostName: Optional[HostName]
    def getIpAddresses
        : ZIO[Any, AwsError, zio.aws.deadline.model.IpAddresses.ReadOnly] =
      AwsError.unwrapOptionField("ipAddresses", ipAddresses)
    def getHostName: ZIO[Any, AwsError, HostName] =
      AwsError.unwrapOptionField("hostName", hostName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.HostPropertiesRequest
  ) extends zio.aws.deadline.model.HostPropertiesRequest.ReadOnly {
    override val ipAddresses
        : Optional[zio.aws.deadline.model.IpAddresses.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddresses())
        .map(value => zio.aws.deadline.model.IpAddresses.wrap(value))
    override val hostName: Optional[HostName] = zio.aws.core.internal
      .optionalFromNullable(impl.hostName())
      .map(value => zio.aws.deadline.model.primitives.HostName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.HostPropertiesRequest
  ): zio.aws.deadline.model.HostPropertiesRequest.ReadOnly = new Wrapper(impl)
}
