package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{InstanceType, HostName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HostPropertiesResponse(
    ipAddresses: Optional[zio.aws.deadline.model.IpAddresses] = Optional.Absent,
    hostName: Optional[HostName] = Optional.Absent,
    ec2InstanceArn: Optional[String] = Optional.Absent,
    ec2InstanceType: Optional[InstanceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.HostPropertiesResponse = {
    import HostPropertiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.HostPropertiesResponse
      .builder()
      .optionallyWith(ipAddresses.map(value => value.buildAwsValue()))(
        _.ipAddresses
      )
      .optionallyWith(
        hostName.map(value => HostName.unwrap(value): java.lang.String)
      )(_.hostName)
      .optionallyWith(ec2InstanceArn.map(value => value: java.lang.String))(
        _.ec2InstanceArn
      )
      .optionallyWith(
        ec2InstanceType.map(value =>
          InstanceType.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceType)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.HostPropertiesResponse.ReadOnly =
    zio.aws.deadline.model.HostPropertiesResponse.wrap(buildAwsValue())
}
object HostPropertiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.HostPropertiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.HostPropertiesResponse =
      zio.aws.deadline.model.HostPropertiesResponse(
        ipAddresses.map(value => value.asEditable),
        hostName.map(value => value),
        ec2InstanceArn.map(value => value),
        ec2InstanceType.map(value => value)
      )
    def ipAddresses: Optional[zio.aws.deadline.model.IpAddresses.ReadOnly]
    def hostName: Optional[HostName]
    def ec2InstanceArn: Optional[String]
    def ec2InstanceType: Optional[InstanceType]
    def getIpAddresses
        : ZIO[Any, AwsError, zio.aws.deadline.model.IpAddresses.ReadOnly] =
      AwsError.unwrapOptionField("ipAddresses", ipAddresses)
    def getHostName: ZIO[Any, AwsError, HostName] =
      AwsError.unwrapOptionField("hostName", hostName)
    def getEc2InstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2InstanceArn", ec2InstanceArn)
    def getEc2InstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("ec2InstanceType", ec2InstanceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.HostPropertiesResponse
  ) extends zio.aws.deadline.model.HostPropertiesResponse.ReadOnly {
    override val ipAddresses
        : Optional[zio.aws.deadline.model.IpAddresses.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddresses())
        .map(value => zio.aws.deadline.model.IpAddresses.wrap(value))
    override val hostName: Optional[HostName] = zio.aws.core.internal
      .optionalFromNullable(impl.hostName())
      .map(value => zio.aws.deadline.model.primitives.HostName(value))
    override val ec2InstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceArn())
      .map(value => value: String)
    override val ec2InstanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceType())
      .map(value => zio.aws.deadline.model.primitives.InstanceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.HostPropertiesResponse
  ): zio.aws.deadline.model.HostPropertiesResponse.ReadOnly = new Wrapper(impl)
}
