package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{IpV6Address, IpV4Address}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpAddresses(
    ipV4Addresses: Optional[Iterable[IpV4Address]] = Optional.Absent,
    ipV6Addresses: Optional[Iterable[IpV6Address]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.IpAddresses = {
    import IpAddresses.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.IpAddresses
      .builder()
      .optionallyWith(
        ipV4Addresses.map(value =>
          value.map { item =>
            IpV4Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipV4Addresses)
      .optionallyWith(
        ipV6Addresses.map(value =>
          value.map { item =>
            IpV6Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipV6Addresses)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.IpAddresses.ReadOnly =
    zio.aws.deadline.model.IpAddresses.wrap(buildAwsValue())
}
object IpAddresses {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.IpAddresses
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.IpAddresses =
      zio.aws.deadline.model.IpAddresses(
        ipV4Addresses.map(value => value),
        ipV6Addresses.map(value => value)
      )
    def ipV4Addresses: Optional[List[IpV4Address]]
    def ipV6Addresses: Optional[List[IpV6Address]]
    def getIpV4Addresses: ZIO[Any, AwsError, List[IpV4Address]] =
      AwsError.unwrapOptionField("ipV4Addresses", ipV4Addresses)
    def getIpV6Addresses: ZIO[Any, AwsError, List[IpV6Address]] =
      AwsError.unwrapOptionField("ipV6Addresses", ipV6Addresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.IpAddresses
  ) extends zio.aws.deadline.model.IpAddresses.ReadOnly {
    override val ipV4Addresses: Optional[List[IpV4Address]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipV4Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.IpV4Address(item)
          }.toList
        )
    override val ipV6Addresses: Optional[List[IpV6Address]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipV6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives.IpV6Address(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.IpAddresses
  ): zio.aws.deadline.model.IpAddresses.ReadOnly = new Wrapper(impl)
}
