package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobAttachmentDetailsEntity(
    jobId: JobId,
    attachments: zio.aws.deadline.model.Attachments
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsEntity = {
    import JobAttachmentDetailsEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsEntity
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .attachments(attachments.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobAttachmentDetailsEntity.ReadOnly =
    zio.aws.deadline.model.JobAttachmentDetailsEntity.wrap(buildAwsValue())
}
object JobAttachmentDetailsEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobAttachmentDetailsEntity =
      zio.aws.deadline.model
        .JobAttachmentDetailsEntity(jobId, attachments.asEditable)
    def jobId: JobId
    def attachments: zio.aws.deadline.model.Attachments.ReadOnly
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getAttachments
        : ZIO[Any, Nothing, zio.aws.deadline.model.Attachments.ReadOnly] =
      ZIO.succeed(attachments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsEntity
  ) extends zio.aws.deadline.model.JobAttachmentDetailsEntity.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val attachments: zio.aws.deadline.model.Attachments.ReadOnly =
      zio.aws.deadline.model.Attachments.wrap(impl.attachments())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsEntity
  ): zio.aws.deadline.model.JobAttachmentDetailsEntity.ReadOnly = new Wrapper(
    impl
  )
}
