package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobAttachmentDetailsError(
    jobId: JobId,
    code: zio.aws.deadline.model.JobEntityErrorCode,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsError = {
    import JobAttachmentDetailsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsError
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .code(code.unwrap)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobAttachmentDetailsError.ReadOnly =
    zio.aws.deadline.model.JobAttachmentDetailsError.wrap(buildAwsValue())
}
object JobAttachmentDetailsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobAttachmentDetailsError =
      zio.aws.deadline.model.JobAttachmentDetailsError(jobId, code, message)
    def jobId: JobId
    def code: zio.aws.deadline.model.JobEntityErrorCode
    def message: String
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getCode: ZIO[Any, Nothing, zio.aws.deadline.model.JobEntityErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsError
  ) extends zio.aws.deadline.model.JobAttachmentDetailsError.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val code: zio.aws.deadline.model.JobEntityErrorCode =
      zio.aws.deadline.model.JobEntityErrorCode.wrap(impl.code())
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsError
  ): zio.aws.deadline.model.JobAttachmentDetailsError.ReadOnly = new Wrapper(
    impl
  )
}
