package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobAttachmentDetailsIdentifiers(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsIdentifiers = {
    import JobAttachmentDetailsIdentifiers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsIdentifiers
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.JobAttachmentDetailsIdentifiers.ReadOnly =
    zio.aws.deadline.model.JobAttachmentDetailsIdentifiers.wrap(buildAwsValue())
}
object JobAttachmentDetailsIdentifiers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsIdentifiers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobAttachmentDetailsIdentifiers =
      zio.aws.deadline.model.JobAttachmentDetailsIdentifiers(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsIdentifiers
  ) extends zio.aws.deadline.model.JobAttachmentDetailsIdentifiers.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsIdentifiers
  ): zio.aws.deadline.model.JobAttachmentDetailsIdentifiers.ReadOnly =
    new Wrapper(impl)
}
