package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{S3Prefix, S3BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobAttachmentSettings(
    s3BucketName: S3BucketName,
    rootPrefix: S3Prefix
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobAttachmentSettings = {
    import JobAttachmentSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobAttachmentSettings
      .builder()
      .s3BucketName(S3BucketName.unwrap(s3BucketName): java.lang.String)
      .rootPrefix(S3Prefix.unwrap(rootPrefix): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobAttachmentSettings.ReadOnly =
    zio.aws.deadline.model.JobAttachmentSettings.wrap(buildAwsValue())
}
object JobAttachmentSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobAttachmentSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobAttachmentSettings =
      zio.aws.deadline.model.JobAttachmentSettings(s3BucketName, rootPrefix)
    def s3BucketName: S3BucketName
    def rootPrefix: S3Prefix
    def getS3BucketName: ZIO[Any, Nothing, S3BucketName] =
      ZIO.succeed(s3BucketName)
    def getRootPrefix: ZIO[Any, Nothing, S3Prefix] = ZIO.succeed(rootPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobAttachmentSettings
  ) extends zio.aws.deadline.model.JobAttachmentSettings.ReadOnly {
    override val s3BucketName: S3BucketName =
      zio.aws.deadline.model.primitives.S3BucketName(impl.s3BucketName())
    override val rootPrefix: S3Prefix =
      zio.aws.deadline.model.primitives.S3Prefix(impl.rootPrefix())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobAttachmentSettings
  ): zio.aws.deadline.model.JobAttachmentSettings.ReadOnly = new Wrapper(impl)
}
