package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait JobAttachmentsFileSystem {
  def unwrap
      : software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem
}
object JobAttachmentsFileSystem {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem
  ): zio.aws.deadline.model.JobAttachmentsFileSystem = value match {
    case software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem.COPIED =>
      val r = COPIED
      r
    case software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem.VIRTUAL =>
      val r = VIRTUAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.JobAttachmentsFileSystem {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem =
      software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem.UNKNOWN_TO_SDK_VERSION
  }
  case object COPIED extends zio.aws.deadline.model.JobAttachmentsFileSystem {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem =
      software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem.COPIED
  }
  case object VIRTUAL extends zio.aws.deadline.model.JobAttachmentsFileSystem {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem =
      software.amazon.awssdk.services.deadline.model.JobAttachmentsFileSystem.VIRTUAL
  }
}
